class IGCListener_Avenger extends UIScreenListener;


event OnInit(UIScreen Screen)
{
	if(`SCREENSTACK.IsInStack(class'UIAvengerHUD'))
	{
		`LOG("+++ ON INIT: AVENGER HUD IN STACK, REALIZING CLOCK +++");
		RealizeClock(Screen);
	}
}

event OnReceiveFocus(UIScreen Screen)
{
	if(`SCREENSTACK.IsInStack(class'UIAvengerHUD'))
	{
		`LOG("+++ ON FOCUS: AVENGER HUD IN STACK, REALIZING CLOCK +++");
		RealizeClock(Screen);
	}
}

/*
event OnLoseFocus(UIScreen Screen)
{
}

event OnRemoved(UIScreen Screen)
{
	Clock.DestroyClock();
}
*/

function RealizeClock(UIScreen Screen)
{
	local UIScreen AvengerHUD;

	AvengerHUD = `SCREENSTACK.GetScreen(class'UIAvengerHUD');
	if(AvengerHUD.GetChildByName('InGameClockBackground', false) == none) 
	{
		`LOG("+++ AVENGER HUD FOUND WITH NO CLOCK, SPAWNING CLOCK. CALLING SCREEN IS: "$string(Screen)$" +++");
		AvengerHUD.Movie.Pres.Spawn(class'UIInGameClock', Screen).InitInGameClock();
	}
	else
	{
		`LOG("+++ CLOCK FOUND, CURRENT SCREEN CLASS IS: "$string(Screen)$" +++");
		switch( `SCREENSTACK.GetCurrentClass() )
		{
		case class'UIFacilityGrid': //Main Avenger screen
		case class'UIPauseMenu': //Pause menu
		//case class'UIAfterAction': //Post battle? Report?
		case class'UISquadSelect': //Pre & post battle squad view
			`LOG("+++ SHOWING CLOCK +++");
			AvengerHUD.GetChildByName('InGameClockBackground').Show();
			AvengerHUD.GetChildByName('InGameClockText').Show();
			break;
		default:
			`LOG("+++ HIDING CLOCK +++");
			AvengerHUD.GetChildByName('InGameClockBackground').Hide();
			AvengerHUD.GetChildByName('InGameClockText').Hide();
		}
	}
}


defaultproperties
{
	ScreenClass = none;
}
